﻿CREATE TABLE Utilisateur
(
	email VARCHAR(110),
	prenom VARCHAR(50) NOT NULL,
	nom VARCHAR(50) NOT NULL,
	mdp VARCHAR(25) NOT NULL,
	pseudo VARCHAR(50) UNIQUE,
	administrateur BOOLEAN,
	CONSTRAINT pk_user PRIMARY KEY (email),
	CONSTRAINT ck_user UNIQUE (prenom, nom)
);

CREATE TABLE Theme
(
	id_theme INTEGER,
	nom_theme VARCHAR(200) UNIQUE,
	description_theme VARCHAR(500),
	CONSTRAINT pk_theme PRIMARY KEY (id_theme)
);

CREATE TABLE Film
(
	id_film INTEGER,
	titre VARCHAR(200),
	annee_sortie INTEGER,
	realisateur VARCHAR(100),
	duree TIME,
	description_film VARCHAR(500),
);

CREATE TABLE Voter   
(

	id_user VARCHAR(110),
	id_theme INTEGER,
	vote_enregistre BOOLEAN,
	CONSTRAINT pk_voter PRIMARY KEY (id_user, id_theme),
	CONSTRAINT fk_user FOREIGN KEY (id_user)
	REFERENCES Utilisateur(email) ON DELETE CASCADE,
	CONSTRAINT fk_v_theme FOREIGN KEY (id_theme)
	REFERENCES Theme(id_theme) ON DELETE CASCADE
);

CREATE TABLE Contenir
(
	id_theme INTEGER,
	id_film INTEGER,
	CONSTRAINT pk_contenir PRIMARY KEY (id_theme, id_film),
	CONSTRAINT fk_c_theme FOREIGN KEY (id_theme)
	REFERENCES Theme(id_theme) ON DELETE CASCADE,
	CONSTRAINT fk_film FOREIGN KEY (id_film)
	REFERENCES Film(id_film) ON DELETE CASCADE
);
